<?php

declare (strict_types=1);
namespace WPForms\Vendor\Square\Models\Builders;

use WPForms\Vendor\Core\Utils\CoreHelper;
use WPForms\Vendor\Square\Models\Error;
use WPForms\Vendor\Square\Models\PauseSubscriptionResponse;
use WPForms\Vendor\Square\Models\Subscription;
use WPForms\Vendor\Square\Models\SubscriptionAction;
/**
 * Builder for model PauseSubscriptionResponse
 *
 * @see PauseSubscriptionResponse
 */
class PauseSubscriptionResponseBuilder
{
    /**
     * @var PauseSubscriptionResponse
     */
    private $instance;
    private function __construct(PauseSubscriptionResponse $instance)
    {
        $this->instance = $instance;
    }
    /**
     * Initializes a new Pause Subscription Response Builder object.
     */
    public static function init() : self
    {
        return new self(new PauseSubscriptionResponse());
    }
    /**
     * Sets errors field.
     *
     * @param Error[]|null $value
     */
    public function errors(?array $value) : self
    {
        $this->instance->setErrors($value);
        return $this;
    }
    /**
     * Sets subscription field.
     *
     * @param Subscription|null $value
     */
    public function subscription(?Subscription $value) : self
    {
        $this->instance->setSubscription($value);
        return $this;
    }
    /**
     * Sets actions field.
     *
     * @param SubscriptionAction[]|null $value
     */
    public function actions(?array $value) : self
    {
        $this->instance->setActions($value);
        return $this;
    }
    /**
     * Initializes a new Pause Subscription Response object.
     */
    public function build() : PauseSubscriptionResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
